using System;

public class Window
{
	// Konstruktor przyjmuje dwie liczby cakowite,
	// aby okreli pooenie w konsoli
	public Window(int top, int left)
	{
		this.top = top;
		this.left = left;
	}

	// Symulacja rysowania okna
	public void DrawWindow()
	{
		Console.WriteLine("Rysowanie okna w punkcie {0}, {1}",
		   top, left);
	}

	// Te skadowe s prywatne, dlatego s niedostpne
	// w metodach klasy pochodnej. Jest to opisane w
	// dalszej czci tego rozdziau
	private int top;
	private int left;
}

// Klasa ListBox dziedziczy po klasie Window
public class ListBox : Window
{
	// Konstruktor ma nowy parametr 
	public ListBox(int top, int left, string theContents)
		:
	base(top, left) // Wywoanie konstruktora klasy bazowej
	{
		mListBoxContents = theContents;
	}

	// Nowa wersja (sowo kluczowe) jest potrzebna, poniewa
	// metoda klasy pochodnej dziaa w inny sposb
	public new void DrawWindow()
	{
		base.DrawWindow(); // Wywoanie metody klasy bazowej
		Console.WriteLine("Zapis acucha znakw do kontrolki klasy ListBox: {0}",
		   mListBoxContents);
	}
	private string mListBoxContents; // Nowa zmienna skadowa
}

public class Tester
{
	public static void Main()
	{
		// Tworzy egzemplarz klasy bazowej
		Window w = new Window(5, 10);
		w.DrawWindow();

		// Tworzy egzemplarz klasy pochodnej
		ListBox lb = new ListBox(20, 30, "Witaj wiecie");
		lb.DrawWindow();
	}
}


